<?php
// This file is part of the mod_coursecertificate plugin for Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Class mod_coursecertificate_observer
 *
 * @package     mod_coursecertificate
 * @copyright   2020 Mikel Martín <mikel@moodle.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class mod_coursecertificate_observer {
    /**
     * Template deleted observer
     *
     * @param \tool_certificate\event\template_deleted $event
     */
    public static function on_template_deleted(\tool_certificate\event\template_deleted $event): void {
        global $DB;
        $records = $DB->get_records('coursecertificate', ['template' => $event->objectid]);
        foreach ($records as $record) {
            $DB->update_record('coursecertificate', (object)['id' => $record->id, 'template' => 0]);
        }
    }
}
