<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * English language pack for Interactivevideo
 *
 * @package    mod_interactivevideo
 * @category   string
 * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitycard'] = "Activity card";
$string['add'] = 'Add';
$string['addinteractiontitle'] = 'Add {$a->name} at {$a->time}';
$string['additionalsettings'] = 'Additional settings';
$string['advanced'] = 'Advanced';
$string['aftercompletion'] = 'After completion';
$string['alignindicatorcenter'] = 'Align interaction indicators center';
$string['allowcustomtheme'] = 'Allow custom theme';
$string['allowcustomtheme_desc'] = 'Check to allow users to select a custom theme for the interactive video instance.';
$string['annotationcontent'] = 'Annotation content';
$string['annotationscopied'] = 'Annotations copied to clipboard';
$string['annotationsimported'] = 'Annotations imported successfully';
$string['annotationssavedasdefaults'] = 'Defaults have been updated successfully.';
$string['appearanceandbehaviorsettings'] = 'Appearance and behavior settings';
$string['appearancesettings'] = 'Appearance settings';
$string['areyousureyouwanttoresetthecompletiondata'] = 'Are you sure you want to reset this user\'s progress? This action will delete all current attempts and associated files.';
$string['atleastonecompletionrule'] = 'At least one completion rule must be set.';
$string['audio'] = 'Audio';
$string['audiovideooptions'] = 'Audio/video options';
$string['auth_tool'] = 'API token/key for {$a}';
$string['auth_tool_desc'] = 'Enter the API token/key for {$a}.';
$string['auto'] = 'Auto';
$string['autohidecontrols'] = 'Autohide controls';
$string['autoplay'] = 'Autoplay';
$string['autoplay_help'] = 'This will not work if the browser does not support or blocks autoplay.';
$string['autoplayblocked'] = 'Autoplay is blocked by your browser or its extension(s).';
$string['avg'] = 'Avg.';
$string['awardpartialpoints'] = 'Award partial points';
$string['backtocourse'] = 'Back to course page';
$string['beforecompletion'] = 'Before completion';
$string['behavioraftercompletion'] = 'Behavior: after completion';
$string['behaviorbeforecompletion'] = 'Behavior: before/without completion';
$string['behaviorsettings'] = 'Behavior settings';
$string['braveautoplay'] = 'The interactive video activity is not supported in Brave browser with autoplay disabled. Please enable autoplay in the browser settings for this site or use a different browser.';
$string['bulkedit'] = 'Bulk edit';
$string['bunnystream'] = 'Bunny Stream';
$string['byauthor'] = 'by {$a}';
$string['cachedef_interactivevideo_settings'] = 'Cache definitions for Interactive Video';
$string['cachedef_iv_items_by_cmid'] = 'Cache definitions for Interactive Video items by course module ID';
$string['cancel'] = 'Cancel';
$string['canvas'] = 'Canvas';
$string['captions'] = 'Captions';
$string['cardsize'] = 'Card size';
$string['cardsize_desc'] = 'Select the default card size for the interactive video instance on the course page.';
$string['centeroncoursepage'] = 'Center on course page';
$string['changeplaybackspeed'] = 'Playback speed';
$string['changevideoquality'] = 'Change video quality';
$string['chapterlist'] = 'Chapter list';
$string['chaptermetadata'] = 'Chapter metadata';
$string['chapters'] = 'Chapters';
$string['chaptertitle'] = 'Chapter title';
$string['chaptertoggle'] = 'Chapter toggle';
$string['checkall'] = 'Check all';
$string['clickability'] = 'Clickable';
$string['clickability_desc'] = 'If checked, the interaction indicator can be clicked to view the interaction content.';
$string['clickaddtoaddinteraction'] = 'Click "Add" to add an interaction';
$string['clone'] = 'Clone';
$string['close'] = 'Close';
$string['closechapterpanel'] = 'Close chapter panel';
$string['completed'] = 'Completed';
$string['completedeletedforthisitem'] = 'Completion data deleted for <b>{$a->item}</b> for <b>{$a->user}</b>';
$string['completionandgrade'] = 'Completion and grade';
$string['completioncompleted'] = 'Completed';
$string['completiondetail:nonexistent'] = 'Unknown condition: {$a}';
$string['completiondetail:percentage'] = 'Complete interactions {$a}%';
$string['completiondetail:watchtillend'] = 'Watch till the end';
$string['completiondisablewarning'] = 'At least one user has completed this activity. To edit the video, you must first unlocked the completion settings. This will also allow the completion status to be re-calculated if applicable.';
$string['completionincomplete'] = 'Incomplete';
$string['completionmanual'] = 'Mark as completed manually';
$string['completionmarkcomplete'] = 'Mark complete';
$string['completionmarkincomplete'] = 'Done';
$string['completionnone'] = 'Not tracked';
$string['completionnotrecordedinpreviewmode'] = 'Completion is not recorded in preview mode.';
$string['completiononcomplete'] = 'Complete the activity';
$string['completiononcompletefull'] = 'Receive a full grade';
$string['completiononcompletepass'] = 'Receive a passing grade (> 50%)';
$string['completiononpass'] = 'Receive a passing grade (> 50%)';
$string['completiononview'] = 'View';
$string['completionpercentage'] = 'Task Completion %';
$string['completionpercentageerror'] = 'Completion percentage must be greater than 0 and less than or equal to 100';
$string['completionpercentagehelp'] = 'Interactions are tasks that users can mark complete when watching the video.';
$string['completionreseterror'] = 'Error resetting completion data.';
$string['completionresetsuccess'] = 'Completion data reset successfully.';
$string['completiontracking'] = 'Completion tracking';
$string['completionwatchtillend'] = 'Watch till the end';
$string['congratulationsyoucompletethisactivity'] = 'CONGRATULATIONS!! You have completed all requirements for this activity!';
$string['content'] = 'Content';
$string['contenttype'] = 'Content types';
$string['contentuploaded'] = 'Content uploaded successfully.';
$string['contentuploaderror'] = 'Error uploading content';
$string['controlsaftercompletion'] = 'Controls: after completion';
$string['controlsbeforecompletion'] = 'Controls: before/without completion';
$string['copied'] = 'Copied!';
$string['copiedtoclipboard'] = 'Link copied to clipboard!';
$string['copy'] = 'Copy';
$string['copynoun'] = 'Copy';
$string['courseindex'] = 'Course index';
$string['createinteractivevideofromlist'] = 'Create interactive video from the list';
$string['currenttime'] = 'Current time';
$string['customdescription'] = 'Custom description';
$string['dailymotion'] = 'Dailymotion';
$string['darkmode'] = 'Use dark mode';
$string['datatableinfo'] = 'Showing _START_ to _END_ of _TOTAL_ entries';
$string['datatableinfoempty'] = 'Showing 0 to 0 of 0 entries';
$string['datatableinfofiltered'] = '(filtered from _MAX_ total entries)';
$string['default'] = 'Default';
$string['defaultappearance'] = 'Default appearance';
$string['defaultappearance_desc'] = 'Select the default appearance settings for the interactive video instance.';
$string['defaultbehavior'] = 'Default behavior';
$string['defaultbehavior_desc'] = 'Select the default behavior settings for the interactive video instance.';
$string['defaulttheme'] = 'Default theme';
$string['defaulttheme_desc'] = 'Select the default theme for the interactive video instance.';
$string['defaulttitle'] = 'Untitled';
$string['defaultvideosource'] = 'Default video/audio source';
$string['defaultvideosource_desc'] = 'Select the default video/audio source for the interactive video instance.';
$string['delete'] = 'Delete';
$string['deletecompletion'] = 'Delete completion';
$string['deletedbyinstructor'] = 'Deleted by instructor';
$string['deleteinteraction'] = 'Delete interaction';
$string['deleteinteractionconfirm'] = 'Are you sure you want to delete this interaction?';
$string['deleterecordforitemforuserconfirm'] = 'Are you sure you want to delete the <b>{$a->item}</b> record for <b>{$a->user}</b>? <br><br><b>Note</b>: This action does not update the completion status, grade, or experience points. Recalculation only occurs when the user re-attempts the activity.';
$string['deleterecordforselectedusers'] = 'Are you sure you want to delete the selected records ({$a})?';
$string['deletevideo'] = 'Delete video/audio';
$string['deletevideobutton'] = '<i class="fa fa-trash fa-fw iv-mr-2"></i>Delete video/audio';
$string['deletevideoconfirm'] = 'Are you sure you want to delete this file?';
$string['disablechapternavigation'] = 'Disable chapter menu';
$string['disablecustomtime'] = 'Disable custom video time';
$string['disablecustomtime_desc'] = 'If checked, users will not be able to set a start time and end time for the video on the activity editing form.';
$string['disableinteractionclick'] = 'Disable interaction click on video navigation';
$string['disableinteractionclickuntilcompleted'] = 'Disable interaction click unless it is completed';
$string['dismissible'] = 'Dismissible';
$string['dismissibleandskippable'] = 'If dismissible, the incomplete interaction can be closed using the close button. <br>If skippable, the incomplete interaction can be skipped. Otherwise, user must complete the interaction before proceeding to the next segment.';
$string['dismissnotallowedbeforecompletion'] = 'You cannot dismiss this interaction before completing it.';
$string['displayasstartscreen'] = 'Display description on start screen';
$string['displaydescriptiononactivityheader'] = 'Display description on activity header';
$string['displayinline'] = 'Display inline on course page';
$string['displayoptions'] = 'Display options';
$string['displayoptionsbottom'] = 'Below the video';
$string['displayoptionsinline'] = 'Inline';
$string['displayoptionspopup'] = 'Popup';
$string['displayoptionsside'] = 'Drawer';
$string['distractionfreemode'] = 'Use distraction-free mode';
$string['download'] = 'Download';
$string['draftsaved'] = 'Changes saved';
$string['duration'] = 'Duration';
$string['dyntube'] = 'Dyntube';
$string['edit'] = 'Edit';
$string['editinteractiontitle'] = 'Edit {$a->name} at {$a->time}';
$string['editinteractiontitlenotime'] = 'Edit {$a}';
$string['editwithctrlclick'] = 'Edit (ctrl/cmd + click for quick edit)';
$string['email'] = 'Email';
$string['enablecontenttypes'] = 'Enabled content types';
$string['enablecontenttypes_desc'] = 'Check to enable the content types.';
$string['enablecoursesettings'] = 'Enable course-level settings';
$string['enablecoursesettings_desc'] = 'Check to enable course-level settings for the interactive video instances.';
$string['enableembedly'] = 'Enable Embedly player library';
$string['enableembedly_desc'] = 'Embedly must be preloaded to run videos from BunnyStream and VioStream. If your site does not use these sources, you can disable this option.';
$string['enablevideosources'] = 'Enabled video/audio sources';
$string['enablevideosources_desc'] = 'Check to enable the video/audio sources.';
$string['end'] = 'End time';
$string['endscreen'] = 'End screen';
$string['endscreentext'] = 'End screen text';
$string['endtime'] = 'End time';
$string['endtimegreaterstarttime'] = 'End time must be greater than the start time.';
$string['endtimelesstotaltime'] = 'Time must be less than the total time of the video.';
$string['endtip'] = '<b>Tip:</b> Right-click to set to current time. Ctrl/Cmd + click to reset the time to the default.';
$string['errorplaynotallowed'] = 'Your browser does not allow automatic playback of the video. Please click the play button to get the video info.';
$string['expand'] = 'Expand';
$string['expected'] = 'Expected';
$string['external'] = 'External';
$string['fastforward200'] = 'Fast forward 0.2s (Ctrl/Cmd for 1s)';
$string['file'] = 'File upload';
$string['filters'] = 'Filter';
$string['first'] = 'First';
$string['firstname'] = 'First name';
$string['fontfamilies'] = 'Font families';
$string['fontfamilies_desc'] = 'Define available font families for the select drop-down. Separate each font by a new line. Use this format: Display name=font-family. Example: Arial=Arial, sans-serif';
$string['formvaluesarereset'] = 'Form values are reset. Please save the form again.';
$string['forward'] = 'Forward';
$string['forwardtooltip'] = 'Fast forward (Right arrow)';
$string['fullavailablewidth'] = 'Full-width poster image';
$string['fullscreen'] = 'Fullscreen';
$string['fullscreenisnotsupported'] = 'Fullscreen is not supported on this device.';
$string['generalsettings'] = 'General settings';
$string['generalsettings_desc'] = 'This is a release candidate version of the Interactive Video plugin. It is recommended to test this plugin in a development environment before deploying it to a production site. Please report any issues to the plugin maintainer: <a href="{$a}">{$a}</a>.';
$string['goto'] = 'Go to';
$string['gradenonzero'] = 'Grade must be greater or equal to 0';
$string['hideinteractions'] = 'Hide interactions on video navigation';
$string['hidemainvideocontrols'] = 'Hide main video controls';
$string['html5video'] = 'HTML5 video/audio upload';
$string['id'] = 'ID';
$string['idlealert'] = 'You have been idle for a while. We stopped the background processes to save your browser\'s memory. Please reload the page to resume.';
$string['import'] = 'Import';
$string['importcontent'] = 'Import contents';
$string['incomplete'] = 'Incomplete';
$string['inprogress'] = 'In progress';
$string['instance'] = 'Instance';
$string['interactionadded'] = 'Interaction added successfully.';
$string['interactionalreadyexists'] = 'An interaction already exists at this time.';
$string['interactionbar'] = 'Interaction bar';
$string['interactioncanonlybeaddedbetweenstartandendtime'] = 'An interaction can only be added between the start ({$a->start}) and end ({$a->end}) times of the video that have been set in the activity settings.';
$string['interactioncount'] = 'Interactions';
$string['interactiondeleted'] = 'Interaction deleted successfully.';
$string['interactionimported'] = 'Interaction imported successfully.';
$string['interactionisbetweentheskipsegment'] = 'You cannot add an interaction between the skip segment.';
$string['interactions'] = 'Interactions';
$string['interactionscannotbeedited'] = '<i class="fa fa-warning iv-mr-2 fa-xl"></i>At least one user has attempted this activity. You can still add new interactions or edit existing ones, but completion status and grade will not be updated until the activity is re-attempted';
$string['interactionsdeleted'] = '{$a} interactions deleted successfully.';
$string['interactionsin'] = 'Interactions in {$a}';
$string['interactionsnotsupportedonlivevideo'] = 'Interactions are not supported on live videos.';
$string['interactionupdated'] = 'Interaction updated successfully.';
$string['interactivevideo'] = 'Interactive video';
$string['interactivevideo:addinstance'] = 'Add interactive video module';
$string['interactivevideo:edit'] = 'Edit interactive video module';
$string['interactivevideo:editreport'] = 'Edit interactive video report';
$string['interactivevideo:manage'] = 'Manage interactive video activities';
$string['interactivevideo:view'] = 'View interactive video module';
$string['interactivevideo:viewreport'] = 'View interactive video report';
$string['interactivevideoname'] = 'Name';
$string['invalidtimeformat'] = 'Please enter a valid time.';
$string['invalidtimestamp'] = 'Invalid timestamp';
$string['invalidtimestampformat'] = 'Invalid timestamp format.';
$string['invalidtoken'] = 'Invalid token';
$string['invalidurlformat'] = 'Invalid URL';
$string['invalidvideourl'] = 'The URL provided is invalid.';
$string['keepcurrent'] = 'Keep current';
$string['keyboardshortcuts'] = '<h5>Keyboard shortcuts:</h5><br><ul class="iv-pl-3"><li><b>Space</b> - Play/Pause</li><li><b>Arrow Right</b> - Forward 1 second</li><li><b>Arrow Left</b> - Rewind 1 second</li><li><b>Plus (+)</b> - Zoom in on the timeline</li><li><b>Minus (-)</b> - Zoom out on the timeline</li><li><b>Ctrl/Cmd + S</b> - Save interactions</li><li><b>A</b> - Launch interaction type list</li><li><b>E</b> - Activate bulk editing</li><li><b>Ctrl/Cmd + A</b> - Select/Deselect interactions</li><li><b>C</b> - Copy selected interactions</li><li><b>D</b> - Download selected interactions</li><li><b>X</b> - Delete selected interactions</li><li><b>I</b> - Launch interaction import form</li><li><b>P</b> - Paste copied interactions</li><li><b>U</b> - Launch the interaction upload form</li></ul>';
$string['kinescope'] = 'Kinescope';
$string['last'] = 'Last';
$string['lastname'] = 'Last name';
$string['launchinpopup'] = 'Launch in popup';
$string['launchvideo'] = 'Launch video';
$string['layer-down'] = 'Layer down';
$string['layer-up'] = 'Layer up';
$string['list'] = 'List';
$string['live'] = 'Live';
$string['lock'] = 'Unlocked: click to lock';
$string['manageivfor'] = 'Manage interactive videos for {$a}';
$string['managevideos'] = 'Manage interactive videos';
$string['max'] = 'Max.';
$string['maximum'] = 'Maximum {$a}';
$string['min'] = 'Min.';
$string['minimum'] = 'Minimum {$a}';
$string['minimumcompletionpercentage'] = 'Complete interactions (%)';
$string['modulename'] = 'Interactive Video';
$string['modulename_help'] = 'Use the Interactive Video module to create interactive videos with tasks and interactions.';
$string['modulenameplural'] = 'Interactive Videos';
$string['moresettings'] = 'More settings';
$string['mute'] = 'Mute';
$string['mutetooltip'] = 'Mute (M)';
$string['nametip'] = '<b>Tip:</b> Right-click to reset the name to the default video title (if any).';
$string['new'] = 'New';
$string['next'] = 'Next';
$string['nocontent'] = 'No content';
$string['nocontentfound'] = 'No contents found.';
$string['nofound'] = 'Not found';
$string['nonzero'] = 'Cannot be zero';
$string['nopermissiontoaddinteractions'] = "You don't have permissions to add interactions.";
$string['nopermissiontoview'] = 'You don\'t have permissions to view the interactive video';
$string['noposterimage'] = 'No poster image';
$string['notaccessreport'] = 'You cannot access the report page.';
$string['notstarted'] = 'Not started';
$string['novideofile'] = 'You must upload a video file.';
$string['novideourl'] = 'You must paste a URL here.';
$string['numeric'] = 'Numbers only';
$string['off'] = 'Off';
$string['openinnewtab'] = 'Open in new tab';
$string['options'] = 'Options';
$string['panopto'] = 'Panopto';
$string['participant'] = 'Participant';
$string['passwordprotected'] = 'Password protected';
$string['passwordprotected_help'] = 'Check this box if the video is password protected. This will make sure the password field is not obstructed by any elements on the page.';
$string['passwordrequired'] = 'Password required';
$string['paste'] = 'Paste';
$string['pause'] = 'Pause';
$string['pauseonblur'] = 'Pause video when tab is inactive';
$string['pausetooltip'] = 'Pause (Space)';
$string['peertube'] = 'PeerTube';
$string['play'] = 'Play';
$string['playbackcontrols'] = 'Playback controls';
$string['playbackrate'] = 'Playback rate';
$string['player'] = 'Player';
$string['playhere'] = 'Play here';
$string['playpause'] = 'Play/Pause';
$string['playtooltip'] = 'Play (Space)';
$string['playvideo'] = 'Play video';
$string['pluginadministration'] = 'Interactive Video administration';
$string['pluginname'] = 'Interactive Video';
$string['posterimage'] = 'Poster image';
$string['preventseeking'] = 'Prevent seeking';
$string['preventskipping'] = 'Prevent skipping';
$string['preventskipping_help'] = 'This setting does not apply to users with editing capabilities.';
$string['preview'] = 'Preview';
$string['previous'] = 'Previous';
$string['privacy:metadata:attachments'] = 'The itemid of the attachment.';
$string['privacy:metadata:char1'] = 'Data stored as Char1.';
$string['privacy:metadata:char2'] = 'Data stored as Char2.';
$string['privacy:metadata:char3'] = 'Data stored as Char3.';
$string['privacy:metadata:completeditems'] = 'A list of completed items.';
$string['privacy:metadata:completiondetails'] = 'The completion details of a user.';
$string['privacy:metadata:completionid'] = 'The ID of the completion.';
$string['privacy:metadata:completionpercentage'] = 'The completion percentage of a user.';
$string['privacy:metadata:interactivevideo_completion'] = 'A user\'s completion status for the interactive video activity.';
$string['privacy:metadata:interactivevideo_log'] = 'A user\'s log for the interactive video activity.';
$string['privacy:metadata:intg1'] = 'Data stored as Intg1.';
$string['privacy:metadata:intg2'] = 'Data stored as Intg2.';
$string['privacy:metadata:intg3'] = 'Data stored as Intg3.';
$string['privacy:metadata:text1'] = 'Data stored as Text1.';
$string['privacy:metadata:text2'] = 'Data stored as Text2.';
$string['privacy:metadata:text3'] = 'Data stored as Text3.';
$string['privacy:metadata:timecompleted'] = 'The time a user completed the activity.';
$string['privacy:metadata:timecreated'] = 'The time the completion status/log was created.';
$string['privacy:metadata:timeended'] = 'The time the video reached the end.';
$string['privacy:metadata:timemodified'] = 'The time the completion status/log was modified.';
$string['privacy:metadata:userid'] = 'The ID of a user.';
$string['privacy:metadata:xp'] = 'The experience points earned by user.';
$string['progress'] = 'Progress';
$string['progressbar'] = 'Progress bar';
$string['providerapis'] = 'Provider APIs';
$string['quality'] = 'Quality';
$string['quicksettings'] = 'Quick settings';
$string['redo'] = "Redo";
$string['refresh'] = 'Refresh';
$string['remainingtime'] = 'Remaining time';
$string['replayaftercompletion'] = 'Replay after completion';
$string['replaybehavior'] = 'Replay behavior';
$string['replycount'] = 'Replies';
$string['report'] = 'Report';
$string['reportfields'] = 'Report fields';
$string['reportfields_desc'] = 'Select the user fields to display in the report.';
$string['reportfor'] = 'Report for {$a}';
$string['reportsettings'] = 'Report settings';
$string['reportwithctrlclick'] = 'Report (ctrl/cmd + click for quick report)';
$string['required'] = 'Required';
$string['requiremintime'] = 'Minimum minutes spent';
$string['requiremintime_help'] = 'The minimum time in minutes that a user must spend on the activity (after the activity is launched) before it can be marked as complete.';
$string['rerun_desc'] = 'If checked, the completed interaction will be forced to rerun when user revisits the segment.';
$string['reset'] = 'Reset';
$string['resetappearancesettings'] = 'Reset appearance settings';
$string['resetbehaviorsettings'] = 'Reset behavior settings';
$string['resetcompletion'] = 'Reset completion';
$string['resetgrades'] = 'Reset grades';
$string['resetintro'] = 'Empty the description';
$string['resetpasswordprotected'] = 'Reset password-protected';
$string['resetsettings'] = 'Reset settings';
$string['resettodefaults'] = 'Reset to defaults';
$string['resettositedefaults'] = 'Reset to site defaults';
$string['resize'] = 'Resize (E)';
$string['restart'] = 'Restart';
$string['resync'] = 'Resync content from content bank';
$string['rewind'] = 'Rewind';
$string['rewind200'] = 'Rewind 0.2s (Ctrl/Cmd for 1s)';
$string['rewindtooltip'] = 'Rewind (Left arrow)';
$string['rightclicktodelete'] = 'Right-click to delete';
$string['rightclicktosetcurrenttime'] = 'Right-click to set to current time. Enter to save.';
$string['rowsselected'] = '%d rows selected';
$string['rumble'] = 'Rumble';
$string['rutube'] = 'RuTube';
$string['save'] = 'Save';
$string['search'] = 'Search';
$string['section'] = 'Section';
$string['sectionname'] = 'Section name';
$string['sectionnum'] = 'Section';
$string['seekingdisabled'] = 'Seeking is disabled.';
$string['segmentendmustbegreaterthantimestamp'] = 'Segment end time must be greater than the start time.';
$string['select'] = 'Select...';
$string['selectacontenttypetoadd'] = 'Select a content type to add';
$string['selectactivity'] = 'Select module';
$string['selectcourse'] = 'Select course';
$string['selectinteraction'] = 'Check your selections.';
$string['selectoruploadcontent'] = 'Select a content from the list or create one';
$string['separatesearchtermsbyslash'] = 'Tip: Use "|" to separate multiple search terms.';
$string['setasdefault'] = 'Set as defaults for this course';
$string['settings'] = 'Settings';
$string['settingssaved'] = 'Settings saved';
$string['settingstooltip'] = 'Settings (Ctrl/Cmd + click for quick settings)';
$string['share'] = 'Share';
$string['sharethismoment'] = 'Share this moment (S)';
$string['showcompletionrequirements'] = 'Show completion requirements';
$string['showindexindf'] = 'Show in distraction-free mode';
$string['showless'] = 'Show less';
$string['showmore'] = 'Show more';
$string['showname'] = 'Show name';
$string['showplaybuttononcoursepage'] = 'Show play button on course page';
$string['showposterimage'] = 'Show poster image';
$string['showposterimageright'] = 'Show poster image on the right';
$string['showprogressbar'] = 'Show progress bar';
$string['skip'] = 'Skip';
$string['skippable'] = 'Skippable';
$string['skipped'] = 'Skipped';
$string['soundcloud'] = 'SoundCloud';
$string['source'] = 'Source';
$string['source_help'] = 'Select the source of the video.';
$string['spendatleast'] = 'Spend at least {$a} minutes';
$string['spotify'] = 'Spotify';
$string['sproutvideo'] = 'SproutVideo';
$string['squareposterimage'] = 'Square poster image';
$string['start'] = 'Start time';
$string['startchapter'] = 'Start';
$string['started'] = 'Started';
$string['startscreen'] = 'Start screen';
$string['starttimelessthanendtime'] = 'Start time must be less than the end time.';
$string['starttimelesstotaltime'] = 'Start time must be less than the total time of the video.';
$string['starttip'] = '<b>Tip:</b> Right-click to set to current time. Ctrl/Cmd + click to reset the time to 00:00:00.';
$string['subplugintype_ivplugin'] = 'Interactive Video Content Type';
$string['subplugintype_ivplugin_plural'] = 'Interactive Video Content Types';
$string['subtitle'] = 'Subtitle';
$string['supportedlinks'] = '<b>Supported sources:</b> {$a}';
$string['taskscompleted'] = 'Tasks completed';
$string['thereisanissueloadingvideo'] = 'There is an issue loading the video.';
$string['thisinteractionalreadyexists'] = 'You cannot add more than one <b>{$a}</b>.';
$string['timecompleted'] = 'Time completed';
$string['timecompletedrange'] = 'Time completed range';
$string['timecreatedrange'] = 'Time started range';
$string['timemodified'] = 'Time modified';
$string['timemustbebetweenstartandendtime'] = 'Time must be within the start ({$a->start}) and end ({$a->end}) times of the video';
$string['timestamp'] = 'Timestamp';
$string['timestarted'] = 'Time started';
$string['timesubmitted'] = 'Time submitted';
$string['tip'] = 'Tip';
$string['title'] = 'Title';
$string['todo'] = 'To do';
$string['togglechapter'] = 'Toggle chapter menu (C)';
$string['togglecompletion'] = 'Toggle completion';
$string['togglecontrols'] = 'Toggle controls';
$string['togglefullscreen'] = 'Toggle fullscreen (F)';
$string['toggleview'] = 'Toggle view';
$string['tutorial'] = 'Tutorial';
$string['type'] = 'Type';
$string['undo'] = "Undo";
$string['unknowncontenttype'] = 'Unknown content type';
$string['unlock'] = 'Locked: click to unlock';
$string['unmute'] = 'Unmute';
$string['unmutetooltip'] = 'Unmute (M)';
$string['unsavedchanges'] = 'You have unsaved changes. Are you sure you want to leave this page?';
$string['updateavailable'] = 'Update available';
$string['upload'] = 'Upload';
$string['uploadanimagebelow'] = 'Upload a poster image below';
$string['uploadannotations'] = 'Upload interactions';
$string['uploadcontent'] = 'Upload content';
$string['uploadvideo'] = 'Upload video/audio';
$string['uploadvideobutton'] = '<i class="fa fa-upload fa-fw iv-mr-2"></i>Upload video/audio';
$string['url'] = 'URL';
$string['usecardonlydesign'] = 'Use minimalist design';
$string['usecolumnlayout'] = 'Use horizontal layout';
$string['usecustomdescription'] = 'Use custom description';
$string['usecustomposterimage'] = 'Use custom poster image';
$string['usefixedratio'] = 'Force 16:9 aspect ratio';
$string['useoriginalvideocontrols'] = 'Use original video controls';
$string['vdocipher'] = 'VdoCipher';
$string['video'] = 'Video';
$string['videocontrols'] = 'Video controls';
$string['videodisplayoptions'] = 'Player options';
$string['videoinformation'] = 'Video information';
$string['videolink'] = 'Direct external video/audio';
$string['videonavhelp'] = '<h5>Tips:</h5><ul class="iv-pl-3"><li>Click on the video navigation bar to seek to a specific time.</li><li>Right-click on the video navigation bar to add a content at a specific time.</li><li>Click on the interaction icon to view its content.</li><li>Right-click on the interaction icon to edit its content.</li><li>Press control/command when fast-forward or rewind to increment by 1 second.</li><li>Press shift and scroll on the timeline to scroll horizontally.</li><li>Press control/command and scroll on the timeline to zoom in/out.</li><li>Drag the interaction icon to change its timestamp.</li></ul>';
$string['videoplayer'] = 'Video player';
$string['videoprogress'] = 'Video progress';
$string['videoquality'] = 'Video quality';
$string['videosharinginstructions'] = 'Site-wide media sharing instructions';
$string['videosharinginstructions_desc'] = 'Enter the instructions for sharing media on the site. For instance, if your organization has specific policies for externally-hosted media, this is a perfect place to specify them. These instructions will be displayed at the top of the activity editing form.';
$string['videotoolbar'] = 'Video toolbar';
$string['videourl'] = 'Video/audio URL';
$string['videourlplaceholder'] = 'Paste a supported URL here';
$string['vidyard'] = 'Vidyard';
$string['views'] = 'Views';
$string['vimeo'] = 'Vimeo';
$string['viostream'] = 'Viostream';
$string['visibilityonvideonav'] = 'Visible on video navigation';
$string['visibilityonvideonav_desc'] = 'If checked, the interaction indicator will be visible on the video navigation bar.';
$string['watch'] = 'Watch';
$string['watched'] = 'Watched %';
$string['wistia'] = 'Wistia';
$string['xp'] = 'XP';
$string['xpcompleted'] = 'XP earned';
$string['xpearned'] = 'You have earned {$a} XPs!';
$string['xplost'] = 'You have lost {$a} XPs!';
$string['xppoint'] = 'Experience points';
$string['yes'] = 'Yes';
$string['youcannotviewthisannotationyet'] = 'You cannot view this content yet.';
$string['youmustcompletethepreviousactivity'] = 'You must complete the previous activity before you can see the rest of the video.';
$string['youmustcompletethistaskfirst'] = 'You must complete this task first.';
$string['youmustspendatleastminutesbeforemarkingcomplete'] = 'You must spend at least <b>{$a->timerequire} minutes</b> before marking this as complete.<br><br><b>Time you spent: {$a->timespent} minutes.</b>';
$string['youtube'] = 'YouTube';
$string['yt'] = 'YouTube';
