<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @copyright 2017 Willian Mano - http://conecti.me
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['pluginname'] = 'Moove Premium';
$string['configtitle'] = 'Moove Premium';
$string['choosereadme'] = 'Moove é um tema moderno e altamente customizável. Este tema tem a intenção de ser usado diretamente, ou como um tema pai ao criar novos themas com Bootstrap 4.';

$string['currentinparentheses'] = '(atual)';
$string['region-side-pre'] = 'Direita';
$string['prev_section'] = 'Seção anterior';
$string['next_section'] = 'Próxima seção';
$string['themedevelopedby'] = 'Este tema foi orgulhosamente desenvolvido por';
$string['themedevelopedbyconectimepartner'] = 'uma empresa Moodle Partner genuinamente Brasileira.';
$string['needsupport'] = 'Precisa de ajuda com seu site Moodle? ';
$string['pleasuretohelp'] = 'Será um prazer ajudar você!';
$string['access'] = 'Acesso';
$string['prev_activity'] = 'Atividade anterior';
$string['next_activity'] = 'Próxima atividade';
$string['donthaveanaccount'] = 'Não possui conta?';
$string['signinwith'] = 'Entre com';

// General settings tab.
$string['generalsettings'] = 'Geral';
$string['logo'] = 'Logo';
$string['logodesc'] = 'A logo que é exibida no cabeçalho.';
$string['favicon'] = 'Ícone Favicon personalizado';
$string['favicondesc'] = 'Envie seu favicon. Deve ser um arquivo do tipo .ico';
$string['preset'] = 'Predefinição do tema';
$string['preset_desc'] = 'Selecione uma predefinição para alterar amplamente o tema.';
$string['presetfiles'] = 'Arquivos de predefinição do tema';
$string['presetfiles_desc'] = 'Arquivos de predefinição usados para alterar completamente a aparência do tema. Ver mais informações em <a href="https://docs.moodle.org/dev/Boost_Presets">Boost presets</a> sobre como criar e compartilhar suas predefinições.';
$string['loginbgimg'] = 'Plano de fundo da tela de login';
$string['loginbgimg_desc'] = 'Envie uma imagem de plano de fundo personalizada para a tela de login.';
$string['brandcolor'] = 'Cor da marca';
$string['brandcolor_desc'] = 'A cor em destaque no site, da fonte e botões.';
$string['secondarymenucolor'] = 'Cor do menu secundário';
$string['secondarymenucolor_desc'] = 'Cor de fundo do menu secundário';
$string['navbarbg'] = 'Cor da barra da navegação';
$string['navbarbg_desc'] = 'Cor da barra de navegação esquerda';
$string['navbarbghover'] = 'Cor hover da barra de navegação esquerda';
$string['navbarbghover_desc'] = 'Cor da barra de navegação esquerda ao passar o mouse';
$string['fontsite'] = 'Fonte do Site';
$string['fontsite_desc'] = 'Fonte padrão do site. Você pode experimentar as fontes em <a href="https://fonts.google.com">Google Fonts</a>.';
$string['enablecourseindex'] = 'Habilitar tópicos do curso';
$string['enablecourseindex_desc'] = 'Exibir ou ocultar tópicos do curso.';
$string['enableclassicbreadcrumb'] = 'Habilitar breadcrum clássico';
$string['enableclassicbreadcrumb_desc'] = 'Esta configuração habilita o breadcrumb clássico, exibindo páginas como curso e categorias.';

// Advanced settings tab.
$string['advancedsettings'] = 'Avançado';
$string['rawscsspre'] = 'SCSS Inicial Puro';
$string['rawscsspre_desc'] = 'Nesse campo você pode fornecer o arquivo de código SCSS inicial, ele será inserido depois de todos outros. Geralmente você vai usar esse arquivo para definir as variáveis.';
$string['rawscss'] = 'SCSS Puro';
$string['rawscss_desc'] = 'Use esse campo para fornecer um arquivo de código SCSS or CSS que irá ser injetado ao final no arquivo de estilos.';
$string['googleanalytics'] = 'Código do Google Analytics V4';
$string['googleanalyticsdesc'] = 'Insira seu código Google Analytics V4 para ativar o Google Analytics no seu site. O formato do código deve ser [G-XXXXXXXXXX]';

// Frontpage settings tab.
$string['frontpagesettings'] = 'Página Inicial';
$string['displaymarketingboxes'] = 'Exibir caixas de Marketing da página inicial';
$string['displaymarketingboxesdesc'] = 'Se você deseja editar os campos de Marketing, selecione Sim <strong>depois clique em SALVAR</strong> para carregar os campos.';
$string['marketingsectionheading'] = 'Título da seção de Marketing';
$string['marketingsectioncontent'] = 'Conteúdo da seção de Marketing';
$string['marketingicon'] = 'Ícone do Marketing {$a}';
$string['marketingheading'] = 'Cabeçalho do Marketing {$a}';
$string['marketingcontent'] = 'Conteúdo do Marketing {$a}';

$string['disableteacherspic'] = 'Desativar foto dos professores';
$string['disableteacherspicdesc'] = 'Essa opçõa oculta a foto dos professores no cartão dos cursos';

$string['sliderfrontpageloggedin'] = 'Exibir slides na página inicial após login?';
$string['sliderfrontpageloggedindesc'] = 'Se habilitado, o slide vai ser exibido na página inicial no lugar da imagem do cabeçalho.';
$string['slidercount'] = 'Quandidade de slides';
$string['slidercountdesc'] = 'Selecione quantos slides você quer adicionar <strong>depois clique em SALVAR</strong> para carregar os campos dos slides.';
$string['sliderimage'] = 'Imagem do slide';
$string['sliderimagedesc'] = 'Adicionar a imagem do slide. Tamanho recomendado: 1500px x 540px ou maior.';
$string['slidertitle'] = 'Título do slide';
$string['slidertitledesc'] = 'Adicionar um título ao slide.';
$string['slidercaption'] = 'Descrição do slide';
$string['slidercaptiondesc'] = 'Adicionar uma descrição ao slide';

$string['numbersfrontpage'] = 'Exibir os números do site';
$string['numbersfrontpagedesc'] = 'Se ativo, exibe o número de usuários e cursos ativos na página inicial.';
$string['numbersfrontpagecontent'] = 'Conteúdo da Seção números';
$string['numbersfrontpagecontentdesc'] = 'Você pode adicionar qualquer texto à esquerda da seção de números.';
$string['numbersfrontpagecontentdefault'] = '<h2>Acreditado por 25,000+ clientes felizes.</h2>
                    <p>Com muitos blocos únicos, você pode facilmente criar <br class="d-none d-sm-block d-md-none d-xl-block">
                        uma página sem usar código. Construa seu próximo site <br class="d-none d-sm-block d-md-none d-xl-block">
                        em poucos minutos.</p>';
$string['numbersusers'] = 'Usuários ativos acessando nossos incríveis recursos!';
$string['numberscourses'] = 'Cursos criados que você pode confiar!';

$string['faq'] = 'FAQ';
$string['faqcount'] = 'Questões da FAQ';
$string['faqcountdesc'] = 'Selecione a quantidade de questões FAQ <strong>depois clique em SALVAR</strong> para liberar so campos.<br>Ao selecionar 0, a área de FAQ não será exibida.';
$string['faqquestion'] = 'Questão FAQ {$a}';
$string['faqanswer'] = 'Resposta FAQ {$a}';

// Footer settings tab.
$string['footersettings'] = 'Rodapé';
$string['website'] = 'URL do site';
$string['websitedesc'] = 'Site principal da Empresa';
$string['mobile'] = 'Celular';
$string['mobiledesc'] = 'Digite o número do telefone ex.: +5598912341234';
$string['mail'] = 'E-Mail';
$string['maildesc'] = 'E-mail de suporte';
$string['tiktok'] = 'TikTok URL';
$string['tiktokdesc'] = 'Insira a URL do seu TikTok. (ex.: http://www.facebook.com/@myinstitution)';
$string['facebook'] = 'Facebook URL';
$string['facebookdesc'] = 'Insira a URL do seu Facebook. (ex.: http://www.facebook.com/myinstitution)';
$string['twitter'] = 'X URL';
$string['twitterdesc'] = 'Insira a URL do seu X. (ex.: http://www.x.com/myinstitution)';
$string['linkedin'] = 'Linkedin URL';
$string['linkedindesc'] = 'Insira a URL do seu Linkedin. (ex.: http://www.linkedin.com/myinstitution)';
$string['youtube'] = 'Youtube URL';
$string['youtubedesc'] = 'Insira a URL do seu Youtube. (ex.: https://www.youtube.com/user/myinstitution)';
$string['instagram'] = 'Instagram URL';
$string['instagramdesc'] = 'Insira a URL do seu Instagram. (ex.: https://www.instagram.com/myinstitution)';
$string['pitnerest'] = 'Pinterest URL';
$string['pitnerestdesc'] = 'Insira a URL do seu Pinterest. (ex.: https://www.pinterest.com/myinstitution)';
$string['whatsapp'] = 'Whatsapp number';
$string['whatsappdesc'] = 'Insira o número de contato do Whatsapp.';
$string['telegram'] = 'Telegram';
$string['telegramdesc'] = 'Insira o número de contato do Telegram ou link de grupo.';
$string['contactus'] = 'Fale conosco';
$string['followus'] = 'Siga-nos';

// Mypublic page.
$string['aboutme'] = 'Sobre mim';
$string['personalinformation'] = 'Informação pessoal';
$string['addcontact'] = 'Adicionar contato';
$string['removecontact'] = 'Remover contato';

// Theme settings.
$string['themesettings:accessibility'] = 'Acessibilidade';
$string['themesettings:fonttype'] = 'Tipo de fonte';
$string['themesettings:defaultfont'] = 'Fonte padrão';
$string['themesettings:dyslexicfont'] = 'Fonte disléxica(o)';
$string['themesettings:enableaccessibilitytoolbar'] = 'Habilitar barra de acessibildade';
$string['themesettingg:successfullysaved'] = 'Configurações de acessibilidade salvas com sucesso';

// Accessibility features.
$string['accessibility:fontsize'] = 'Tamanho da fonte';
$string['accessibility:decreasefont'] = 'Diminuir tamanho da fonte';
$string['accessibility:resetfont'] = 'Reiniciar tamanho da fonte';
$string['accessibility:increasefont'] = 'Aumentar tamanho da fonte';
$string['accessibility:sitecolor'] = 'Cor do Site';
$string['accessibility:resetsitecolor'] = 'Reiniciar cor do site';
$string['accessibility:sitecolor2'] = 'Baixo contraste 1';
$string['accessibility:sitecolor3'] = 'Baixo contraste 2';
$string['accessibility:sitecolor4'] = 'Alto contraste';

// Data privacy.
$string['privacy:metadata:preference:accessibilitystyles_fontsizeclass'] = 'A preferência do usuário para o tipo de fonte.';
$string['privacy:metadata:preference:accessibilitystyles_sitecolorclass'] = 'A preferência do usuário para a cor da fonte.';
$string['privacy:metadata:preference:thememoovesettings_fonttype'] = 'A preferência do usuário para o tipo de fonte.';
$string['privacy:metadata:preference:thememoovesettings_enableaccessibilitytoolbar'] = 'A preferência do usuário para habilitar a barra de accessibilidade.';

$string['privacy:accessibilitystyles_fontsizeclass'] = 'A preferência atual para o tamanho da fonte é: {$a}.';
$string['privacy:accessibilitystyles_sitecolorclass'] = 'A preferência atual para a cor do site é: {$a}.';
$string['privacy:thememoovesettings_fonttype'] = 'A preferência atual para o tipo de fonte é: {$a}.';
$string['privacy:thememoovesettings_enableaccessibilitytoolbar'] = 'A preferência atual para habilitar a barra de acessibilidade é exibir.';

// Premium settings.
$string['premiumsettings'] = 'Premium';
$string['disableorangefooter'] = 'Desabilitar rodapé laranja';
$string['darkmode_enable'] = 'Habilitar modo escuro';
$string['loginposition'] = 'Posição da caixa de login';
$string['loginposition_desc'] = 'Posição em que a caixa de acesso será exibida na página de login.';
$string['loginposition_left'] = 'Esquerda';
$string['loginposition_center'] = 'Centralizado';
$string['loginposition_right'] = 'Direita';
$string['configreportstitle'] = 'Características adicionais';
$string['configreportstext'] = '<div class="alert alert-info"><p>Moove Premium inclui alguns relatórios extras especialmente para você.</p><p class="mb-0">Para acessá-los, visite Administração do Site > Relatórios.</p></div>';
$string['alternativelogin'] = 'URL de login alternativo';
$string['alternativelogin_desc'] = 'Seus usuários serão redirecionados para esta URL ao acessarem a página de login.';
$string['alternativelogintext'] = 'Texto alternativo da URL de login';
$string['alternativelogintext_desc'] = 'O texto exibido no botão da URL de login alternativa.';

// License Settings.
$string['licensingsettings'] = 'Registro';
$string['licensenotactive'] = '<b>Alert!</b> Licença não ativada, por favor ative sua licença nas configurações do tema.';
$string['licensenotactiveadmin'] = '<b>Alert!</b> Licença não ativada, por favor ative sua licença  <a href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingmoove#theme_moove_licensing" >clicando aqui</a>.';
$string['licensekey'] = 'Chave da licença';
$string['licensekey_desc'] = 'Digite a chave de licença informada no site PluginStore.';
$string['licensestatus'] = 'Status da Licença';
$string['active'] = 'Ativa';
$string['invalid'] = 'Licença inválida';
$string['expired'] = 'Expirada';
$string['activationcode'] = 'Código de ativação';

$string['_msg'] = 'Não foi possível se conectar ao site pluginstore para validar sua licença. Verifique seu firewall ou qualquer outro bloqueio em seu servidor.';
$string['active_msg'] = 'Licença ativa';
$string['invalid_msg'] = 'Chave de licença inválida';
$string['expired_msg'] = 'Licença expirada';
$string['alreadyregistered_msg'] = 'Licença já registrada para outro site';

// Reports.
$string['moove:viewreports'] = 'Ver relatórios do Moove';
$string['reports'] = 'Relatórios do Moove';
$string['report_graphs'] = 'Relatórios Gráficos';
$string['report_period'] = 'Relatórios por Período';
$string['report_onlineusers'] = 'Usuários online';

$string['seeperiodreport'] = 'Ver Informações do relatório por período';
$string['totalusers'] = 'Usuários';
$string['onlineusers'] = 'Usuários Online';
$string['totalcourses'] = 'Cursos';
$string['totalenrolments'] = 'Inscrições';

$string['graph_newusers'] = 'Gráfico de novos usuários';
$string['graph_newenrolments'] = 'Gráfico de novas inscrições';
$string['graph_coursesconclusions'] = 'Gráfico de conclusões por curso';
$string['graph_topenrolmentcourses'] = 'Top 10 cursos com mais inscrições';
$string['graph_topconclusionscourses'] = 'Top 10 cursos com mais conclusões';

$string['startdate'] = 'Data Inicial';
$string['enddate'] = 'Data Final';
$string['inthisperiodwehad'] = 'Nesse período tivemos: ';
$string['filter'] = 'Filtros';
$string['newusers'] = 'Novos Usuários';
$string['newenrolments'] = 'Novas Inscrições';
$string['conclusions'] = 'Conclusões de Curso';
$string['enrolmentsbycourse'] = 'Inscrições por Curso';
$string['conclusionsbycourse'] = 'Conclusões por Curso';
$string['shortname'] = 'Nome Curto';
$string['qtd'] = 'Quantidade';
$string['siteactivity'] = 'Atividade no site';
$string['starttime'] = 'Date e hora de início';
$string['endtime'] = 'Data e hora de fim';
$string['onlineusers_error'] = 'Erro!';
$string['onlineusers_error_desc'] = 'Você não pode escolher um período maior do que uma hora.';

$string['hvpcss'] = 'H5P CSS';
$string['hvpcss_desc'] = 'CSS personalizado que será aplicado nas atividades H5P';

// Redirect page
$string['redirectmessage'] = 'Carregando...';
$string['redirectbtntext'] = 'Se a página não redirecionar automaticamente, clique aqui para prosseguir.';
